# -*- coding: utf-8 -*-
"""
Created on Thu Jul 25 16:39:39 2024

@author: yys
"""
import re
import os
import pandas as pd
import numpy as np


# folder_path = "D:\\guo\\RS-BNU\\sh\\30m\\all+met+brt+blb+irt+lwp\\onlyok\\"
# folder_path = "D:/guo/RS-BNU/bj/wutk_onlyok/ls/sx/sx+ear5/"
folder_path = "D:\\guo\\RS-BNU\\gz\\sx+era5\\"

# 获取文件夹内所有CSV文件的文件名
csv_files = [file for file in os.listdir(folder_path) if file.endswith('.csv')]

# 循环读取每个CSV文件并将其合并到merged_data中
for csv_file in csv_files:
    file_path = os.path.join(folder_path, csv_file)
    # name=csv_file[0:10]
    print('处理'+csv_file)
    csv = csv_file.split('.')[0]
    data=pd.read_csv(file_path)
    data_2d = data.values
    ls1=int(data_2d.shape[0]/115)
    data_3d=data_2d.reshape((ls1, 115, 538))
    for i, slice_2d in enumerate(data_3d): 
        # print(i)

        if np.all(slice_2d[:, 10] < 85) and np.all(slice_2d[:, -1] < 85):
            print(f"第 {i} 个二维切片的第10列和最后一列所有值均小于85")
            continue
        else:
        # # 不符合条件，将该切片改为 NaN
            data_3d[i] = np.nan
            print(f"第 {i} 个二维切片的第10列和/或最后一列有值不小于85，已修改为 NaN")
    # 2ddata = data.values
    # tktime = pd.to_datetime(name, format='%Y%m%d%H')
      
    data_2d_new=data_3d.reshape((ls1*115, 538))
    data_new=pd.DataFrame(data_2d_new,columns=data.columns)
    data_new = data_new.dropna(how='all')
    data_new.to_csv(folder_path+'\\qu85\\'+csv+'qu85_2y.csv',index=False)

